---
name: Bug report
about: Create a report to help us improve
---

**Before you submit:**

- [ ] Please read the [contributing guidelines](CONTRIBUTING.md)
- [ ] Please search through the existing issues (both open AND closed) to see if your issue has been discussed before. Github issue search can be used for this: https://github.com/imgix/vue/issues?utf8=%E2%9C%93&q=is%3Aissue
- [ ] Please ensure the problem has been isolated and reduced. This link explains more: http://css-tricks.com/6263-reduced-test-cases/

**Describe the bug**
A clear and concise description of what the bug is. Please strive to reach the **root problem** of your issue to avoid the XY problem. See more: https://meta.stackexchange.com/questions/66377/what-is-the-xy-problem

**To Reproduce**
A bug is a _demonstrable problem_ that is caused by the code in the repository. Thus, the contributors need a way to reproduce your issue - if we can't reproduce your issue, we can't help you! Also, please be as detailed as possible.

[a link to a codesandox or repl.it; here is a link to a codesandbox with @imgix/vue installed which can be forked: https://codesandbox.io/s/vue-imgix-base-codesandbox-bhz8n]

[alternatively, please provide a code example]

```js
// A *self-contained* demonstration of the problem follows...
// This should be able to be dropped into a file with @imgix/vue installed and just work
```

Steps to reproduce the behaviour:

1.  Go to '...'
2.  Click on '....'
3.  Scroll down to '....'
4.  See error

**Expected behaviour**
A clear and concise description of what you expected to happen.

**Screenshots**
If applicable, add screenshots to help explain your problem.

**Information:**

- @imgix/vue version: [e.g. v1.0]
- browser version: [include link from [https://www.whatsmybrowser.org/](https://www.whatsmybrowser.org/) or details about the OS used and browser version]

**Additional context**
Add any other context about the problem here.
